<?php

require 'vendor/autoload.php';

use PagVc\Api\Amount;
use PagVc\Api\Payer;
use PagVc\Api\Payment;
use PagVc\Api\RedirectUrls;
use PagVc\Api\Transaction;

//Payer Object
$payer = new Payer();
$payer->setPaymentMethod('PagVc'); //Tipo de pagamento - PagVc, Pix ...

//Amount Object
$amountIns = new Amount();
$amountIns->setTotal(4.99)->setCurrency('BRL'); //Valor e tipo de moeda

//Transaction Object
$trans = new Transaction();
$trans->setAmount($amountIns);

//RedirectUrls Object
$urls = new RedirectUrls();
$urls->setSuccessUrl('http://your-merchant-domain.com/example-success.php'); //Url de sucesso

$urls->setCancelUrl('http:/your-merchant-domain.com/'); //Url de cancelamento para retornar ao site

$urls->setGatewayReference('REF123'); //Codigo de referencia ou ordem do produto que recebe junto com o webhook
$urls->setIpnUrl('http://#'); //endereco do webhook que recebe a informacao que o pagamento foi realizado

//Payment Object
$payment = new Payment();

$payment->setCredentials([ //Client ID & Secret = Merchants->setting
    'client_id'     => '', //Client ID você obtem como comerciante express 
    'client_secret' => '', //Secret 
])
->setRedirectUrls($urls)
->setPayer($payer)
->setTransaction($trans);

try {
    $payment->create(); //Cria o link de pagamento
    header("Location: " . $payment->getApprovedUrl()); //Redireciona para a url de checkout
}
catch (\Exception $ex)
{
    print $ex;
    exit;
}
